<?php
/***************************************
## Theme URI: https://www.chenxingweb.com/wordpress-theme-cx-multi.html
## Author: 晨星博客
## Author URI: https://www.chenxingweb.com
## Description: 简洁时尚自适应博客杂志类主题，有问题请加QQ群597157500请求帮助。
## Theme Name: CX-MULTI
## Version: 1.0
****************************************/

function cx_global_option() {
    global $cx_option;
    $cx_option = get_option( MD5(CX_THEMES_NAME) );
}
call_user_func('cx_global_option');

// 适配 wp_body_open 函数
if (!function_exists('wp_body_open')) :
    function wp_body_open(){
        do_action( 'wp_body_open' );
    }
endif;

// 获取主题参数
if (!function_exists('cx_option')) :
    function cx_option($optname = '', $default = false,$option = null){
        global $cx_option;
        $cxoption = $option? ( is_array($option) ? $option : cx_option($option) ) : $cx_option;
        return ($cxoption && isset($cxoption[$optname])) ? $cxoption[$optname] : $default;
    }
endif;

// 开关调用
if (!function_exists('cx_switcher')) :
    function cx_switcher($optname = '',$default = false,$option = null){
        global $cx_option;
        $cxoption = $option? $option : $cx_option;
        return ($cxoption && isset($cxoption[$optname])) ? (bool)$cxoption[$optname] : $default;
    }
endif;

// 获取主题模版
if (!function_exists('cx_templatefile')) :
    function cx_templatefile($templname = ''){
        if( $templname ){
            $dirname = apply_filters('cxtheme-templatefile',get_theme_file_path('template/default/'.$templname),$templname);
            if( is_file($dirname) ){
                require $dirname;
                return;
            }
        }
        require get_theme_file_path('template/default/index.php');
        return;
    }
endif;

// 获取用户IP
if (!function_exists('cx_getuserip')) :
    function cx_getuserip() {
        $user_ip = $_SERVER['REMOTE_ADDR'];
        if (isset($_SERVER['HTTP_CLIENT_IP']) && preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_CLIENT_IP'])) {
            $user_ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif(isset($_SERVER['HTTP_X_FORWARDED_FOR']) AND preg_match_all('#\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}#s', $_SERVER['HTTP_X_FORWARDED_FOR'], $matches)) {
            foreach ($matches[0] AS $xip) {
                if (!preg_match('#^(10|172\.16|192\.168)\.#', $xip)) {
                    $user_ip = $xip;
                    break;
                }
            }
        }
        return $user_ip;
    }
endif;

// 本周更新文章数量
if (!function_exists('cx_update_postnum')) :
    function cx_update_postnum($type = '',$cat = null) {
        $date_query = array(
            array(
                'after' =>  $type ? $type : '1 month ago' // 1 week ago
            )
        );
        $args = array(
            'post_type'        => 'post',
            'post_status'      => 'publish',
            'date_query'       => $date_query,
            'no_found_rows'    => true,
            'suppress_filters' => true,
            'fields'           => 'ids',
            'posts_per_page'   => - 1
        );
        if( $cat ){
            $args['cat'] = $cat;
        }
        $query = new WP_Query($args);
        return (int)$query->post_count;
    }
endif;

// 随机标签云
if (!function_exists('cx_rand_tags')) :
    function cx_rand_tags(){
        global $post, $wpdb;
        $sql = "SELECT * FROM {$wpdb->prefix}terms wt INNER JOIN {$wpdb->prefix}term_taxonomy wtt on wt.term_id=wtt.term_id where wtt.taxonomy='post_tag' ORDER BY RAND() LIMIT 15";
        $related_posts = $wpdb->get_results($sql);
        $html = '<ul class="wp-tag-cloud">';
        foreach($related_posts as $tag){
            $tag_link = get_tag_link($tag->term_id);
            $html .= "<li><a href='{$tag_link}' target='_blank' title='{$tag->name} Tag' class='{$tag->slug}'>";
            $html .= "{$tag->name}</a></li>";
        }
        $html .= '</ul>';
        echo $html;
    }
endif;

// 输出缩略图地址
if (!function_exists('cx_post_thumb')) :
    function cx_post_thumb($post_id = 0,$default = '') {
        if(empty($post_id)){
            global $post;
            $post_id = $post->ID;
        }
        $thumbnail_src   = apply_filters('post_thumbnail', '', $post_id, $default);
        if( $thumbnail_src ) return $thumbnail_src;
        if($post_img_src = get_post_meta($post_id, 'cx_thumbnail_src', true)){
            $thumbnail_src = $post_img_src;
        }elseif (has_post_thumbnail($post_id)) {
            $thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post_id) , 'full');
            $thumbnail_src = $thumbnail_src[0];
        } else {
            $posts  = get_post($post_id);        
            $output = preg_match_all('/<img.*?(?: |\\t|\\r|\\n)?src=[\'"]?(.+?)[\'"]?(?:(?: |\\t|\\r|\\n)+.*?)?>/sim', $posts->post_content, $matches);
            if (!empty($matches[1][0])) {
                $thumbnail_src = $matches[1][0];
            } else {
                $thumbnail_src = $default ? $default : cx_option('_defimages'); // 文章没有图片时调用的默认图片
            }
        }
        return $thumbnail_src;
    }
endif;

// 时间格式显示N天前
if (!function_exists('cx_timeago')) :
    function cx_timeago($ptime) {
        if(!is_int($ptime)) $ptime = strtotime($ptime);    
        $etime = time() - $ptime;
        if ($etime < 1) return '刚刚';
        $interval = array(
            12 * 30 * 24 * 60 * 60 => '年前',
            30 * 24 * 60 * 60 => '个月前',
            7 * 24 * 60 * 60 => '周前',
            24 * 60 * 60 => '天前',
            60 * 60 => '小时前',
            60 => '分钟前',
            1 => '秒前'
        );
        foreach ($interval as $secs => $str) {
            $d = $etime / $secs;
            if ($d >= 1) {
                $r = round($d);
                return $r . $str;
            }
        }
    }
endif;

// 调用模版
if (!function_exists('cx_template_html')) :
    function cx_template_html( $type = '',$before = '', $after = '',$echo = true,$post = null ) {
        if( !$post ) global $post;
        $post_id    = $post->ID;
        $post_link  = get_the_permalink($post_id);
        $post_title = get_the_title($post_id);
        $post_live  = (int)get_post_meta($post_id, '_cx_postlive', true);

        // 图片模块
        $post_thumb  = '';
        $post_thumb .= '<div class="scale-thumb-box">';
        $post_thumb .= '<div class="post-thumb-box" style="background-image: url('.cx_post_thumb($post_id).');">';
        $post_thumb .= '<span class="overlay"></span>';
        $post_thumb .= '</div>';
        $post_thumb .= '</div>';

        $html  = '';
        $html .= $before;
        $html .= '<div class="'.( $type ? $type . '-' : '') . 'post-archive transform-scale">';
        switch ($type) {
            case 'slide':
                $html .= '<a href="'.$post_link.'">';
                $html .= $post_thumb;
                $html .= '<div class="post-meta-box">';
                $html .= '<h3>'.$post_title.'</h3>';
                $html .= '<p>'.wp_trim_words($post->post_content,90,'...').'</p>';
                $html .= '</div>';
                $html .= '</a>';
            break; case 'rslide':
                $html .= '<a href="'.$post_link.'">';
                $html .= $post_thumb;
                $html .= '<div class="post-meta-box">';
                $html .= '<h3>'.$post_title.'</h3>';
                $html .= '</div>';
                $html .= '</a>';
            break; default:
                $html .= '<a href="'.$post_link.'">';
                $html .= $post_thumb;
                $html .= '</a>';
                $html .= '<div class="post-meta-box">';
                $html .= '<a href="'.$post_link.'">';
                $html .= '<h3>'.$post_title.'</h3>';
                $html .= '<div class="post-metadata">';
                $html .= '<span class="multi-left">'.cx_timeago( get_the_time('Y-m-d H:i:s') ).'</span>';
                $html .= '<span class="multi-right"><i class="cxthemeicon cxicon-liulan"></i> '.(int)get_post_meta($post_id, 'views', true).'</span>';
                $html .= '<span class="multi-right"><i class="cxthemeicon cxicon-tubiao2"></i> '.$post_live.'</span>';
                $html .= '</div>';
                $html .= '</a>';
                $html .= '</div>';
                
            break;
        }
        $html .= '</div>';
        $html .= $after;
        if( !$echo ) return $html;
        echo $html;
    }
endif;

