<?php
/***************************************
## Theme URI: https://www.chenxingweb.com/wordpress-theme-cx-multi.html
## Author: 晨星博客
## Author URI: https://www.chenxingweb.com
## Description: 简洁时尚自适应博客杂志类主题，有问题请加QQ群597157500请求帮助。
## Theme Name: CX-MULTI
## Version: 1.4
****************************************/

if (!defined('CX_THEMES_NAME'))     define('CX_THEMES_NAME', 'CX-MULTi' );
if (!defined('CX_THEMES_VERSION'))  define('CX_THEMES_VERSION', '1.4' );

require get_template_directory() . '/admin/index.php';
require get_template_directory() . '/inc/theme-option.php';
require get_template_directory() . '/classes/optimization.class.php';
require get_template_directory() . '/classes/menuwalker.class.php';


add_action( 'after_setup_theme',              'cxmulti_setup' );         //初始化主题
add_action( 'wp_enqueue_scripts',             'cxmulti_scripts' );       // 加载脚本文件
add_filter( 'get_the_archive_title',          'cxmulti_archive_title' ); // 列表标签处理
add_action( 'wp_ajax_cxajax_postlive',        'cxmulti_postlive' );      // 喜欢功能
add_action( 'wp_ajax_nopriv_cxajax_postlive', 'cxmulti_postlive' );      // 喜欢功能
add_action( 'wp_footer',                      'cxmulti_postviews');      // 浏览计数
add_action('wp_head',                         'cxmulti_diystyle_code',99);  // 挂载css自定义代码
add_action('wp_footer',                       'cxmulti_diyjs_code',99);     // 挂载js脚本代码
add_action('wp_footer',                       'cxmulti_diyhtml_code',98);   // 挂载自定义html代码

function cxmulti_diyhtml_code($html){
    $html    = '';
    $diycode = cx_option('diycode_fields_html');
    if( !empty($diycode) && md5($diycode) != 'b13ab5e89ace010cec3efca1a5ec8cc1' ){
        $html .= ( !empty($html) ? "\n" : '' ).$diycode;
    }
    if( empty($html) ) return;
    $rehtml = "\n".$html."\n";
    echo $rehtml;
}

function cxmulti_diyjs_code($script){
    $script   = '';
    $diycode  = cx_option('diycode_fields_js');
    if( !empty($diycode) && md5($diycode) != 'f7b13b0d371e823024812b593060ed45' ){
        $script .= ( !empty($script) ? "\n" : '' ).$diycode;
    }
    if( empty($script) ) return;
    $rescript = "\n".'<script type="text/javascript">'."\n".$script."\n</script>\n";
    echo $rescript;
}

function cxmulti_diystyle_code($style){
    $style   = '';
    $diycode = cx_option('diycode_fields_css');
    if( !empty($diycode) && md5($diycode) != 'ed405139bc4245b0e59c73369d504d72' ){
        $style .= ( !empty($style) ? "\n" : '' ).$diycode;
    }
    if( empty($style) ) return;
    $restyle = "\n".'<style type="text/css">'."\n".$style."\n</style>\n";
    echo $restyle;
}

function cxmulti_postviews(){
    if( !is_single() ) return;
    $post_id    = get_the_ID();
    $post_view  = (int)get_post_meta($post_id, 'views', true);
    $post_view++;
    update_post_meta($post_id, 'views', $post_view);
}


function cxmulti_postlive(){
    $post_id = isset($_GET['postid']) ? (int)$_GET['postid'] : 0;
    $return  = ['start' => 'error','msg' => '请求错误，请重试！','data' => null];
    if( $post_id ){
        $post_live = (int)get_post_meta($post_id, '_cx_postlive', true);
        $post_live++;
        update_post_meta($post_id, '_cx_postlive', $post_live);
        $expire       = time()+3600*24;
	    $domain       = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
	    setcookie('_postlive_'.$post_id,$post_id,$expire,'/',$domain,false);
        $return['start'] = 'ok';
        $return['msg']   = $post_live.'人喜欢';
    }
    echo wp_json_encode($return);
    exit;
}

function cxmulti_setup() {

    add_theme_support( 'title-tag' );
    add_theme_support( 'post-thumbnails' );
    //set_post_thumbnail_size( 1568, 9999 );

    register_nav_menus(
        array(
            'header' => '主菜单',
            'footer' => '底部菜单',
        )
    );

    register_sidebar( array(
        'name'          => __( '文章侧边栏','cx-udy'),
        'id'            => 'sidebar-single',
        'description'   => __( '显示在文章侧边位置','cx-udy' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3><span>',
        'after_title'   => '</span></h3>'
    ));	

    add_theme_support(
        'html5',
        array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
            'script',
            'style',
        )
    );

}

function cxmulti_scripts() {
    wp_enqueue_style( 'cxtheme-icon', '//at.alicdn.com/t/font_1916367_amhbhxhta7u.css', array(), '1.0' );
    wp_enqueue_style( 'layui-style', '//www.layuicdn.com/layui-v2.5.6/css/layui.css', array(), '2.5.6' );
    wp_enqueue_style( 'cxmulti-style', get_stylesheet_uri(), array(), wp_get_theme()->get( 'Version' ) );
    //wp_enqueue_style( 'cxmulti-style', get_stylesheet_uri(), array(), wp_get_theme()->get( 'Version' ) );
    //wp_enqueue_script( 'jquery');
    wp_enqueue_script( 'layui-js', '//www.layuicdn.com/layui-v2.5.6/layui.js', array(), '2.5.6', true );
    //wp_enqueue_script( 'layui-js', get_theme_file_uri( '/js/layui/layui.js' ), array(), '2.5.6', true );
    wp_enqueue_script( 'cxmulti-js', get_theme_file_uri( '/js/main.js' ), array(), wp_get_theme()->get( 'Version' ), true );
    //wp_enqueue_script( 'cxmulti-js', get_theme_file_uri( '/js/main.js' ), array(), time(), true );
    wp_localize_script( 'cxmulti-js', 'cxtheme', array(
        'themedir' => get_theme_file_uri(),
        'ajaxurl'  => admin_url('admin-ajax.php'),
    ) );
}


function cxmulti_archive_title($title){
    if( is_category() ){
        $term   = get_queried_object();
        $title  = single_cat_title( '', false );        
        $title .= '<span class="layui-badge">共'.$term->count.'篇</span>';
    } elseif ( is_tag() ) {
        $title = sprintf( __( '<em>#</em> %s <em>#</em><span class="cxmulti-botsolid"></span>' ), single_tag_title( '', false ) );
    }
    return $title;
}

