<?php
/***************************************
## Theme URI: https://www.chenxingweb.com/wordpress-theme-cx-multi.html
## Author: 晨星博客
## Author URI: https://www.chenxingweb.com
## Description: 简洁时尚自适应博客杂志类主题，有问题请加QQ群597157500请求帮助。
## Theme Name: CX-MULTI
## Version: 1.0
****************************************/

class Cx_Optimization {

    // 功能控制
    public $optiondata;

    // 加载类项目
    public static function action(){
		global $Cx_Optimization;
        $Cx_Optimization = new self();
        $Cx_Optimization->option_data();
		$Cx_Optimization->begin();	
    }
    
    public function option_data(){
        $option_data = [];
        if( cx_switcher('optimize-json') )      $option_data[] = 'wp-json';
        if( cx_switcher('optimize-emoji') )     $option_data[] = 'emoji';
        if( cx_switcher('optimize-head') )      $option_data[] = 'headtag';
        if( cx_switcher('optimize-embeds') )    $option_data[] = 'embeds';
        if( cx_switcher('optimize-google') )    $option_data[] = 'google';
        if( cx_switcher('optimize-library') )   $option_data[] = 'library';
        if( !function_exists('no_category_base_refresh_rules') && 
            cx_switcher('basic-nocategoty') )   $option_data[] = 'nocategoty';
        $this->optiondata = apply_filters('cxtheme-optimization-data',(array)$option_data);
    }

    // 类核心
	function begin(){
        
        if( empty($this->optiondata) || !is_array($this->optiondata) ) return;

        //移除wp-json链接
        if( in_array('wp-json',$this->optiondata) ):
            add_filter('rest_enabled',            '_return_false');
            add_filter('rest_jsonp_enabled',      '_return_false');
            remove_action( 'wp_head',             'rest_output_link_wp_head', 10 );
            remove_action( 'wp_head',             'wp_oembed_add_discovery_links', 10 );
        endif;

        //删除emoji脚本
        if( in_array('emoji',$this->optiondata) ):
            remove_action( 'admin_print_scripts', 'print_emoji_detection_script');
            remove_action( 'admin_print_styles',  'print_emoji_styles');
            remove_action( 'wp_head',             'print_emoji_detection_script', 7);
            remove_action( 'wp_print_styles',     'print_emoji_styles');
            remove_filter( 'the_content_feed',    'wp_staticize_emoji');
            remove_filter( 'comment_text_rss',    'wp_staticize_emoji');
            remove_filter( 'wp_mail',             'wp_staticize_emoji_for_email');
        endif;

        //移除头部冗余代码
        if( in_array('headtag',$this->optiondata) ):
            remove_action( 'wp_head',             'wp_generator' );// WP版本信息
            remove_action( 'wp_head',             'rsd_link' );// 离线编辑器接口
            remove_action( 'wp_head',             'wlwmanifest_link' );// 同上
            remove_action( 'wp_head',             'rel_canonical' );
            remove_action( 'wp_head',             'adjacent_posts_rel_link_wp_head', 10, 0 );// 上下文章的url
            remove_action( 'wp_head',             'feed_links', 2 );// 文章和评论feed
            remove_action( 'wp_head',             'feed_links_extra', 3 );// 去除评论feed
            remove_action( 'wp_head',             'wp_shortlink_wp_head', 10, 0 );// 短链接
        endif;

        // 移除顶部工具栏
        add_filter('show_admin_bar',          '__return_false');

        //禁用embeds功能
        if( in_array('embeds',$this->optiondata) ):
            add_action( 'init',                   [&$this,'disable_embeds_init'], 9999 );
            register_activation_hook( __FILE__,   [&$this,'disable_embeds_remove_rewrite_rules'] );
            register_deactivation_hook( __FILE__, [&$this,'disable_embeds_flush_rewrite_rules'] );
        endif;
        
        // 禁用谷歌字体 
        if( in_array('google',$this->optiondata) ):       
            add_action( 'init',                   [&$this,'wp_remove_open_sans_from_wp_core'] );
        endif;

        //移除 block-library CSS
        if( in_array('library',$this->optiondata) ): 
            add_action( 'wp_enqueue_scripts',     [&$this,'remove_block_library_css'], 100 );
        endif;

        // 分类去除category/前缀
        if( in_array('nocategoty',$this->optiondata) ): 
            register_activation_hook(__FILE__,   [&$this,'no_category_base_refresh_rules']);
            register_deactivation_hook(__FILE__, [&$this,'no_category_base_deactivate']);
            add_action('created_category',       [&$this,'no_category_base_refresh_rules']);
            add_action('delete_category',        [&$this,'no_category_base_refresh_rules']);
            add_action('edited_category',        [&$this,'no_category_base_refresh_rules']);
            add_action('init',                   [&$this,'no_category_base_permastruct']);
            add_filter('category_rewrite_rules', [&$this,'no_category_base_rewrite_rules']);
            add_filter('query_vars',             [&$this,'no_category_base_query_vars']);
            add_filter('request',                [&$this,'no_category_base_request']); 
        endif;
    }

    function no_category_base_refresh_rules(){
        global $wp_rewrite;
        $wp_rewrite->flush_rules();
    }

    function no_category_base_deactivate(){
        remove_filter('category_rewrite_rules', [$this,'no_category_base_rewrite_rules']); // We don't want to insert our custom rules again
        $this->no_category_base_refresh_rules();
    }

    function no_category_base_permastruct(){
        global $wp_rewrite;
        global $wp_version;
        if ($wp_version >= 3.4) {
            $wp_rewrite->extra_permastructs['category']['struct'] = '%category%';
        } else {
            $wp_rewrite->extra_permastructs['category'][0] = '%category%';
        }
    }

    function no_category_base_rewrite_rules($category_rewrite){
        global $wp_rewrite;
        $category_rewrite = array();
        if (class_exists('Sitepress')) {
            global $sitepress;
            remove_filter('terms_clauses', array($sitepress, 'terms_clauses'));
            $categories = get_categories(array('hide_empty' => false));
            add_filter('terms_clauses', array($sitepress, 'terms_clauses'));
        } else {
            $categories = get_categories(array('hide_empty' => false));
        }

        foreach ($categories as $category) {
            $category_nicename = $category->slug;

            if ($category->parent == $category->cat_ID) {
                $category->parent = 0;
            } elseif ($category->parent != 0) {
                $category_nicename = get_category_parents($category->parent, false, '/', true) . $category_nicename;
            }

            $category_rewrite['(' . $category_nicename . ')/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$']    = 'index.php?category_name=$matches[1]&feed=$matches[2]';
            $category_rewrite["({$category_nicename})/{$wp_rewrite->pagination_base}/?([0-9]{1,})/?$"] = 'index.php?category_name=$matches[1]&paged=$matches[2]';
            $category_rewrite['(' . $category_nicename . ')/?$']                                       = 'index.php?category_name=$matches[1]';
        }

        // Redirect support from Old Category Base
        $old_category_base                               = get_option('category_base') ? get_option('category_base') : 'category';
        $old_category_base                               = trim($old_category_base, '/');
        $category_rewrite[$old_category_base . '/(.*)$'] = 'index.php?category_redirect=$matches[1]';
        return $category_rewrite;
    }

    function no_category_base_query_vars($public_query_vars){
        $public_query_vars[] = 'category_redirect';
        return $public_query_vars;
    }

    function no_category_base_request($query_vars){
        if (isset($query_vars['category_redirect'])) {
            $catlink = trailingslashit(get_option('home')) . user_trailingslashit($query_vars['category_redirect'], 'category');
            status_header(301);
            header("Location: $catlink");
            exit();
        }

        return $query_vars;
    }


    // 移除 block-library CSS
    function remove_block_library_css() {
        wp_dequeue_style( 'wp-block-library' );
    }

    // 禁用谷歌字体
    function wp_remove_open_sans_from_wp_core() {
        wp_deregister_style( 'open-sans' );
        wp_register_style( 'open-sans', false );
        wp_enqueue_style('open-sans','');

        wp_deregister_style( 'wp-editor-font' );
        wp_register_style( 'wp-editor-font', false );
        wp_enqueue_style('wp-editor-font','');
    }

    //禁用embeds功能
	function disable_embeds_init() {
	    global $wp;
	    $wp->public_query_vars = array_diff( $wp->public_query_vars, array(
	        'embed',
	    ) );
	    remove_action( 'rest_api_init',      'wp_oembed_register_route' );
	    add_filter( 'embed_oembed_discover', '__return_false' );
	    remove_filter( 'oembed_dataparse',   'wp_filter_oembed_result', 10 );
	    remove_action( 'wp_head',            'wp_oembed_add_discovery_links' );
	    remove_action( 'wp_head',            'wp_oembed_add_host_js' );
	    add_filter( 'tiny_mce_plugins',      array($this,'disable_embeds_tiny_mce_plugin') );
	    add_filter( 'rewrite_rules_array',   array($this,'disable_embeds_rewrites') );
	}
	    
	function disable_embeds_tiny_mce_plugin( $plugins ) {
	    return array_diff( $plugins, array( 'wpembed' ) );
	}
	function disable_embeds_rewrites( $rules ) {
	    foreach ( $rules as $rule => $rewrite ) {
	        if ( false !== strpos( $rewrite, 'embed=true' ) ) {
	            unset( $rules[ $rule ] );
	        }
	    } 
	    return $rules;
	}
	function disable_embeds_remove_rewrite_rules() {
	    add_filter( 'rewrite_rules_array', array($this,'disable_embeds_rewrites') );
	    flush_rewrite_rules();
	}
    
}
Cx_Optimization::action();