<?php
/***************************************
## Theme URI: https://www.chenxingweb.com/wordpress-theme-cx-multi.html
## Author: 晨星博客
## Author URI: https://www.chenxingweb.com
## Description: 简洁时尚自适应博客杂志类主题，有问题请加QQ群597157500请求帮助。
## Theme Name: CX-MULTI
## Version: 1.0
****************************************/

class CX_Header_MenuNav extends Walker_Nav_Menu {

    var $number = 1;

    function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul class=\"layui-nav-child\">\n";
    }

    function start_el( &$output, $item, $depth = 0, $args = [], $id = 0 ) {
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
        //print_r($item);
        $class_names = $value = '';
        $fa_arr      = $class_new = [];
        $classes     = empty( $item->classes ) ? [] : (array) $item->classes;
        
        $class_names = apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args );
        if( empty($depth) ){
            $class_new[] = 'layui-nav-item';
        }
        
        if( !empty($class_names) && is_array($class_names) ){
            foreach ($class_names as $key => $class_value) {
                if( strpos($class_value,'fa') !== false ){
                    $fa_arr[] = $class_value;
                    unset($class_names[$key]);
                }
                if( $class_value == 'menu-item-has-children'){
                    $class_new[] = 'menu-item-has-children';
                }
                if( $class_value == 'current-menu-item'){
                    $class_new[] = 'layui-this';
                }
            }
        }
        $class_names = join( ' ', $class_new);
        $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
        //$class_names = str_replace("current-menu-item","current",$class_names);

        $output .= $indent . '<li' . $value . $class_names .'>';

        $atts = array();
        $atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
        $atts['target'] = ! empty( $item->target )     ? $item->target     : '';
        $atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
        $atts['href']   = ! empty( $item->url )        ? $item->url        : '';

        $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );

        $attributes = '';
        foreach ( $atts as $attr => $value ) {
            if ( ! empty( $value ) ) {
                $value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }
        
        $item_output = $args->before;
        $item_output .= '<a'. $attributes .'>';
        if( !empty($fa_arr) && is_array($fa_arr) ){
            $fa_class = join( ' ', $fa_arr);
            $item_output .= '<i class="'.$fa_class.'"></i> ';
        }
        $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
        $item_output .= '</a>';
        $item_output .= $args->after;

        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }

}