<?php
/***************************************
## Theme URI: https://www.chenxingweb.com/wordpress-theme-cx-multi.html
## Author: 晨星博客
## Author URI: https://www.chenxingweb.com
## Description: 简洁时尚自适应博客杂志类主题，有问题请加QQ群597157500请求帮助。
## Theme Name: CX-MULTI
## Version: 1.0
****************************************/
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>><?php wp_body_open(); ?>
    <div class="multi-container">
        <header class="multi-header-box">
            <div class="multi-main-box">
                <div class="multi-logo-box multi-left">
                    <a href="<?php echo home_url(); ?>"><img src="<?php echo cx_option('header-logo');?>" alt="<?php echo bloginfo('name');?>"></a>
                </div>
                <div class="multi-header-menu multi-left layui-hide-xs">
                    <ul class="layui-nav multi-nav-white">
                        <?php 
						wp_nav_menu([
                            'container'      => false,
                            'items_wrap'     => '%3$s',
                            'theme_location' => 'header',
                            'walker'         => new CX_Header_MenuNav()
                        ]);
					    ?>
                    </ul>
                </div>
                
                <div class="multi-xs-menu multi-right layui-show-xs-inline">
                    <i class="cxthemeicon cxicon-menu multi-xsmenu-js" style="font-size: 24px;"></i>
                    <div class="multi-xs-menu-data">
                        <div class="menu-data-bg"></div>
                        <ul class="layui-nav multi-nav-white layui-nav-tree">
                            <?php 
                            wp_nav_menu([
                                'container'      => false,
                                'items_wrap'     => '%3$s',
                                'theme_location' => 'header',
                                'walker'         => new CX_Header_MenuNav()
                            ]);
                            ?>
                        </ul>
                    </div>
                </div>

                <?php
                if( cx_switcher('header-login') ):
                ?>

                <div class="multi-header-data multi-right ">
                    
                <?php
                if( is_user_logged_in() ){
                    global $current_user;
                    $words_lang = (preg_match("/[\x7f-\xff]/", $current_user->display_name)) ? 4 :6;
                    ?>
                    <ul class="layui-nav multi-nav-white">
                        <li class="layui-nav-item">
                            <a href="javascript:;"><i class="cxthemeicon cxicon-zhanghao"></i> <?php echo wp_trim_words($current_user->display_name,$words_lang);?></a>
                            <dl class="layui-nav-child">
                                <dd><a href="<?php echo admin_url( 'profile.php' );?>"><i class="cxthemeicon cxicon-zhanghao"></i> 用户中心</a></dd>
                                <dd><a href="<?php echo wp_logout_url( home_url() );?>"><i class="cxthemeicon cxicon-tubiao30"></i> 退出登录</a></dd>
                            </dl>
                        </li>
                    </ul>
                    <?php
                }else{
                    ?>
                    <a class="multi-xs-login layui-show-xs-inline" href="<?php echo wp_login_url( home_url() );?>"><i class="cxthemeicon cxicon-zhanghao" style="font-size: 18px;"></i></a>
                    <ul class="layui-nav multi-nav-white layui-hide-xs">
                        <li class="layui-nav-item">
                            <a href="<?php echo wp_login_url( home_url() );?>" style="padding:0 5px;display:inline-block;">登录</a> | 
                            <a href="<?php echo wp_registration_url();?>" style="padding:0 0 0 5px;display:inline-block;">注册</a>
                        </li>
                    </ul>
                    <?php
                }
                ?>
                            
                        
                    
                </div>

                <?php
                endif;
                ?>

                <div class="multi-header-search multi-right layui-hide-xs">
                    <form action="<?php echo home_url(); ?>" method="get">
                        <button class="iconfont-hd btn-search" type="submit"><i class="layui-icon layui-icon-search"></i></button>
                        <input class="top-input" name="s" type="text" autocomplete="off" placeholder="搜索关键词..." title="搜索关键词...">
                    </form>
                </div>
            </div>
        </header><!-- #masthead -->

        <div id="content" class="multi-content">