﻿using System;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace TH
{
    public class SqlHelper
    {      
        public static string ConnString = "Data Source = " + Login.SqlDBIP + ";Initial Catalog = " + Login.SqlDBName + ";User ID = " + Login.SqlDBUser + ";Password = " + Login.SqlDBNassword + "";
        public static byte[] StringToByte(string strSource)
        {
            string[] str = new string[32];
            str = strSource.Split(',');

            byte[] bteste = new byte[32];
            for (int i = 0; i < str.Length; i++)
            {
                bteste[i] = Convert.ToByte(str[i]);
            }

            return bteste;
        }



        /// <summary>
        /// 判断表是否存在
        /// </summary>
        /// <param name="strTableName_"></param>
        /// <returns></returns>
        public static bool selDB(string strTableName_)
        {
            bool bExist = false;
            try
            {
                using (SqlConnection conn = new SqlConnection(ConnString))
                {
                    string strExist = @"select count(*) from dbo.sysobjects where id=object_id('" + strTableName_ + @"')" + @" and ObjectProperty(id,N'IsUserTable')=1";
                    using (SqlCommand cmd = conn.CreateCommand())
                    {
                        PrepareCommand(cmd, CommandType.Text, strExist, null);
                        conn.Open();
                        int nNum = (int)cmd.ExecuteScalar();
                        bExist = (0 != nNum);
                    }
                }
            }
            catch (Exception e)
            {
                throw new Exception("Xugd.Table.IsExisted() " + e.Message, e);
            }
            return bExist;
        }

        #region ExecuteNonQuery

        /// <summary>
        /// 执行所有的添加，删除，更新操作都可以执行
        /// </summary>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>如果执行成功返回1,反之返回0</returns>
        public static int ExecuteNonQuery(CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            int reValue = 0;
            using (SqlConnection conn = new SqlConnection(ConnString))
            {
                using (SqlCommand cmd = conn.CreateCommand())
                {
                    PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                    conn.Open();
                    reValue = cmd.ExecuteNonQuery();
                    cmd.Parameters.Clear();
                }
                conn.Close();
                conn.Dispose();
            }
            return reValue;
        }


        /// <summary>
        /// 执行所有的添加，删除，更新操作都可以执行
        /// </summary>
        /// <param name="conn"></param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>如果执行成功返回1,反之返回0</returns>
        public static int ExecuteNonQuery(SqlConnection conn, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            int reValue = 0;
            using (SqlCommand cmd = conn.CreateCommand())
            {
                PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                if (conn.State != ConnectionState.Open)
                    conn.Open();
                reValue = cmd.ExecuteNonQuery();
                cmd.Parameters.Clear();
            }
            conn.Close();
            conn.Dispose();
            return reValue;
        }

        /// <summary>
        /// 执行所有的添加，删除，更新操作都可以执行
        /// </summary>
        /// <param name="conn"></param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>如果执行成功返回1,反之返回0</returns>
        public static int ExecuteNonQuery(string connstring, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            int reValue = 0;
            using (SqlConnection conn = new SqlConnection(connstring))
            {
                using (SqlCommand cmd = conn.CreateCommand())
                {
                    PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                    if (conn.State != ConnectionState.Open)
                        conn.Open();
                    reValue = cmd.ExecuteNonQuery();
                    cmd.Parameters.Clear();
                }
                conn.Close();
                conn.Dispose();
            }
            return reValue;
        }
        #endregion

        #region ExecuteReader

        /// <summary>
        /// 根据sql语句，执行查询
        /// </summary>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回sqldatareader读取的信息</returns>
        public static SqlDataReader ExecuteReader(CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            SqlDataReader reReader;
            SqlConnection conn = new SqlConnection(ConnString);
            using (SqlCommand cmd = conn.CreateCommand())
            {
                PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                if (conn.State != ConnectionState.Open)
                    conn.Open();
                reReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Parameters.Clear();

            }
            conn.Close();
            conn.Dispose();
            return reReader;
        }
        /// <summary>
        ///  根据sql语句，执行查询
        /// </summary>
        /// <param name="conn">连接数据库字符串</param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回sqldatareader读取的信息</returns>
        public static SqlDataReader ExecuteReader(SqlConnection conn, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            SqlDataReader reReader;
            using (SqlCommand cmd = conn.CreateCommand())
            {
                PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                if (conn.State != ConnectionState.Open)
                    conn.Open();
                reReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Parameters.Clear();
            }
            conn.Close();
            conn.Dispose();
            return reReader;
        }
        /// <summary>
        ///  根据sql语句，执行查询
        /// </summary>
        /// <param name="conn">连接数据库字符串</param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回sqldatareader读取的信息</returns>
        public static SqlDataReader ExecuteReader(string connstring, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            SqlDataReader reReader;
            SqlConnection conn = new SqlConnection(connstring);
            using (SqlCommand cmd = conn.CreateCommand())
            {
                PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                if (conn.State != ConnectionState.Open)
                    conn.Open();
                reReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Parameters.Clear();

            }
            conn.Close();
            conn.Dispose();
            return reReader;
        }

        #endregion

        #region SqlDataReader_Move
        /// <summary>
        /// 为SqlDataReader向前移动指定的记录数。不对传入的SqlDataReader作任何等其它操作。
        /// </summary>
        /// <param name="dr">可用的SqlDataReader对象</param>
        /// <param name="MoveRecorderNum">移动的记录数</param>
        /// <returns>移动成功true，如果移动到了尾行返回false</returns>
        public static bool SqlDataReader_Move(SqlDataReader dr, int MoveRecorderNum)
        {
            bool reValue = true;
            try
            {
                while (0 < MoveRecorderNum)
                {
                    MoveRecorderNum--;
                    if (!dr.Read())
                    {
                        reValue = false;
                        break;
                    }
                }
            }
            catch
            {
                throw;
            }
            return reValue;
        }
        #endregion

        #region ExecuteScalar
        /// <summary>
        /// 根据sql语句，执行相应的操作
        /// </summary>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回object类型</returns>
        public static object ExecuteScalar(CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            object reValue;
            //try
            //{
            using (SqlConnection conn = new SqlConnection(ConnString))
            {
                using (SqlCommand cmd = conn.CreateCommand())
                {
                    PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                    conn.Open();
                    //if (cmd.ExecuteScalar()!=DBNull.Value)
                    //{
                    reValue = cmd.ExecuteScalar();
                    //}
                    //else
                    //{
                    //    reValue = 0;
                    //}
                    cmd.Parameters.Clear();
                }
                conn.Close();
                conn.Dispose();
            }
            return reValue;
            //}
            //catch
            //{
            //    return 0;
            //}
        }

        /// <summary>
        /// 根据sql语句，执行相应的操作
        /// </summary>
        /// <param name="conn">连接数据库字符串</param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回object类型</returns>
        public static object ExecuteScalar(SqlConnection conn, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            object reValue;
            using (SqlCommand cmd = conn.CreateCommand())
            {
                PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                if (conn.State != ConnectionState.Open)
                    conn.Open();
                reValue = cmd.ExecuteScalar();
                cmd.Parameters.Clear();
            }
            conn.Close();
            conn.Dispose();
            return reValue;
        }

        /// <summary>
        /// 根据sql语句，执行相应的操作
        /// </summary>
        /// <param name="conn">连接数据库字符串</param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回object类型</returns>
        public static object ExecuteScalar(string connstring, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            object reValue;
            using (SqlConnection conn = new SqlConnection(connstring))
            {
                using (SqlCommand cmd = conn.CreateCommand())
                {
                    PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                    conn.Open();
                    reValue = cmd.ExecuteScalar();
                    cmd.Parameters.Clear();
                }
                conn.Close();
                conn.Dispose();
            }
            return reValue;
        }
        #endregion

        #region ExecuteDataTable

        /// <summary>
        /// 根据传入的sql语句查询出数据存贮在Datatable中
        /// </summary>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回Datatable</returns>
        public static DataTable ExecuteDataTable(CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            DataTable reData = new DataTable();
            using (SqlConnection conn = new SqlConnection(ConnString))
            {
                using (SqlCommand cmd = conn.CreateCommand())
                {
                    PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                    using (SqlDataAdapter sda = new SqlDataAdapter(cmd))
                    {
                        conn.Open();
                        sda.Fill(reData);
                    }
                    cmd.Parameters.Clear();
                }
                conn.Close();
                conn.Dispose();
            }
            return reData;
        }

        /// <summary>
        /// 根据传入的sql语句查询出数据存贮在Datatable中
        /// </summary>
        /// <param name="conn">连接数据库语句</param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回Datatable</returns>
        public static DataTable ExecuteDataTable(SqlConnection conn, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            DataTable reData = new DataTable();
            using (SqlCommand cmd = conn.CreateCommand())
            {
                PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                using (SqlDataAdapter sda = new SqlDataAdapter(cmd))
                {
                    if (conn.State != ConnectionState.Open)
                        conn.Open();
                    sda.Fill(reData);
                }
                cmd.Parameters.Clear();
            }
            conn.Close();
            conn.Dispose();
            return reData;
        }

        /// <summary>
        /// 根据传入的sql语句查询出数据存贮在Datatable中
        /// </summary>
        /// <param name="conn">连接数据库语句</param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        /// <returns>返回Datatable</returns>
        public static DataTable ExecuteDataTable(string connstring, CommandType cmdType, string cmdText, params SqlParameter[] cmdParams)
        {
            DataTable reData = new DataTable();
            using (SqlConnection conn = new SqlConnection(connstring))
            {
                using (SqlCommand cmd = conn.CreateCommand())
                {
                    PrepareCommand(cmd, cmdType, cmdText, cmdParams);
                    using (SqlDataAdapter sda = new SqlDataAdapter(cmd))
                    {
                        conn.Open();
                        sda.Fill(reData);
                    }
                    cmd.Parameters.Clear();
                }
                conn.Close();
                conn.Dispose();
            }
            return reData;
        }

        #endregion

        //-----------------------------------------------------------------------------------
        public static DataSet GetDDL(string commString)
        {
            DataSet ds = new DataSet();
            using (SqlConnection conn = new SqlConnection(ConnString))
            {
                SqlDataAdapter adapter = new SqlDataAdapter();
                using (adapter.SelectCommand = new SqlCommand())
                {
                    adapter.SelectCommand.CommandType = CommandType.Text;
                    adapter.SelectCommand.CommandText = commString;
                    adapter.SelectCommand.Connection = conn;

                    adapter.Fill(ds, "Users");
                }
                conn.Close();
                conn.Dispose();
            }
            return ds;
        }

        #region CloseConnection

        /// <summary>
        /// 关闭sqlconnection的连接
        /// </summary>
        /// <param name="conn">传入连接数据库的字符串</param>
        public static void CloseConnection(SqlConnection conn)
        {
            if (conn.State != ConnectionState.Closed)
                conn.Close();
        }
        #endregion

        #region PrepareCommand

        /// <summary>
        /// 为sqlcommand增加，将所有的传入的parameter变量
        /// </summary>
        /// <param name="cmd">sqlcommand</param>
        /// <param name="cmdType">sqlcommand类型</param>
        /// <param name="cmdText">sql语句</param>
        /// <param name="cmdParams">传入的参数</param>
        private static void PrepareCommand(SqlCommand cmd, CommandType cmdType, string cmdText, SqlParameter[] cmdParams)
        {
            cmd.CommandText = cmdText;
            cmd.CommandType = cmdType;
            if (cmdParams != null)
            {
                foreach (SqlParameter param in cmdParams)
                {
                    if (param != null)
                    {
                        cmd.Parameters.Add(param);
                    }
                }
            }
        }
        #endregion
    }
}