﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MySql.Data.MySqlClient;
namespace TH
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();

            if (Login.SqlDBIP != null)
            {
                label3.Text = Login.SqlDBIP;
            }
            else
            {
                label3.Text = "taohuadongle";
            }

            
        }
        //声明全局变量
        public static string TH_WorkLogID;        
        public static string WorkLogSelect;
        
        ///////////////
        //点击关闭时
        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            //Environment.Exit(0);
            Application.Exit();
        }

        ///////////////
        //点击用户查询
        private void Sys_User_Click(object sender, EventArgs e)
        {
            App.Sys_User sys_User = new App.Sys_User();
            sys_User.Show();
            this.Hide();
        }

        ///////////////
        //点击多项目管理项目报告
        private void PM_ProjSure_Click(object sender, EventArgs e)
        {
            App.PM_ProjSure pM_ProjSure = new App.PM_ProjSure();
            pM_ProjSure.Show();
            this.Hide();
        }


        ///////////////
        //流程所属目录查询
        private void WF_Process_Click(object sender, EventArgs e)
        {
            App.WF_Process wF_Process = new App.WF_Process();
            wF_Process.Show();
            this.Hide();
        }

        ///////////////
        //数据字典所属目录查询
        private void SYS_Dictionary_Click(object sender, EventArgs e)
        {
            App.SYS_Dictionary sYS_Dictionary = new App.SYS_Dictionary();
            sYS_Dictionary.Show();
            this.Hide();
        }

        ///////////////
        //平台问题反馈
        private void Button_TH_PTWT_Click(object sender, EventArgs e)
        {
            App.TH_PTWT tH_PTWT = new App.TH_PTWT();
            tH_PTWT.Show();
            this.Hide();
        }


        /*---------------------------------------------------------个人日志-----------------------------------------------------------------------------------*/
        //切换至个人日志时
        private void TabPage2_Enter(object sender, EventArgs e)
        {
            //设置WorkLogSelect=0，使用的是全部查询
            WorkLogSelect = "0";
            //查询日志数据 前100条
            string sql1 = @"SELECT ID,WorkingDay,CreateName,WorkLog FROM TH_WorkLog ORDER BY WorkingDay DESC,CreateDate  LIMIT 0,100;";
            DataSet ds = MySqlHelper.GetDataSet(MySqlHelper.Conn, CommandType.Text, sql1);
            //赋值
            rowMergeView1.DataSource = ds.Tables[0];
            //对Column_RQ日期列合并
            this.rowMergeView1.MergeColumnNames.Add("Column_RQ");
            //设置行高
            rowMergeView1.ColumnHeadersHeight = 30;
            rowMergeView1.ColumnHeadersHeightSizeMode = DataGridViewColumnHeadersHeightSizeMode.DisableResizing;
            //设置一级标题
            rowMergeView1.AddSpanHeader(2, 2, "个人日志");
            //
            
        }

        /////////////
        //点击日志数据时
        private void RowMergeView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            TH_WorkLogID = rowMergeView1.CurrentRow.Cells["Column_ID"].Value.ToString();
            string sql1 = "SELECT WorkingDay,CreateName,WorkLog FROM TH_WorkLog WHERE ID = '" + TH_WorkLogID + "'";
            DataTable dt = MySqlHelper.GetDataSet(MySqlHelper.Conn, CommandType.Text, sql1, null).Tables[0];
            //赋值
            dateTimePicker1.DataBindings.Clear();
            dateTimePicker1.DataBindings.Add("Value", dt, "WorkingDay");
            textBox1.DataBindings.Clear();
            textBox1.DataBindings.Add("Text", dt, "CreateName");
            richTextBox1.DataBindings.Clear();
            richTextBox1.DataBindings.Add("Text", dt, "WorkLog");
        }
        
        /////////////
        //点击查询
        private void button_Select_Click(object sender, EventArgs e)
        {
            //设置WorkLogSelect=1，使用的是条件查询功能
            WorkLogSelect = "1";
            string sql1 = @"SELECT ID,WorkingDay,CreateName,WorkLog FROM TH_WorkLog WHERE CreateName =   '" + textBox1.Text + "' ORDER BY WorkingDay DESC,CreateDate  LIMIT 0,100;";
            DataSet ds = MySqlHelper.GetDataSet(MySqlHelper.Conn, CommandType.Text, sql1);
            //赋值            
            rowMergeView1.DataSource = ds.Tables[0];
        }

        /////////////
        //点击新增时
        private void Button_Work_Click(object sender, EventArgs e)
        {
            string sql1 = @"INSERT INTO TH_WorkLog (ID,WorkingDay,CreateName,CreateDate,WorkLog)
                            VALUES (UUID(),DATE_FORMAT( '" + dateTimePicker1.Value.ToShortDateString() + "','%Y-%m-%d'),'" + textBox1.Text + "', SYSDATE(),'" + richTextBox1.Text + "');";            
            MySqlHelper.ExecuteNonQuery(MySqlHelper.Conn, CommandType.Text, sql1, null);

            //调用查询
            if(WorkLogSelect == "1")
            {
                button_Select_Click(this, e);
            }
            else
            {
                TabPage2_Enter(this, e);
            }
        }

        /////////////
        //点击修改
        private void Button_Update_Click(object sender, EventArgs e)
        {
            string sql1 = @"UPDATE TH_WorkLog SET WorkingDay =  DATE_FORMAT('" + dateTimePicker1.Value.ToShortDateString() + "','%Y-%m-%d'),CreateName =   '" + textBox1.Text + "' ,WorkLog = '" + richTextBox1.Text + "'  WHERE ID =  '" + TH_WorkLogID + "'";
            MySqlHelper.ExecuteNonQuery(MySqlHelper.Conn, CommandType.Text, sql1, null);

            //调用查询
            if (WorkLogSelect == "1")
            {
                button_Select_Click(this, e);
            }
            else
            {
                TabPage2_Enter(this, e);
            }
            MessageBox.Show("修改成功");
        }

        /////////////
        //点击删除
        private void Button_Delete_Click(object sender, EventArgs e)
        {
            string sql1 = @"DELETE FROM  TH_WorkLog  WHERE ID =  '" + TH_WorkLogID + "'";
            MySqlHelper.ExecuteNonQuery(MySqlHelper.Conn, CommandType.Text, sql1, null);

            //调用查询
            if (WorkLogSelect == "1")
            {
                button_Select_Click(this, e);
            }
            else
            {
                TabPage2_Enter(this, e);
            }
            MessageBox.Show("删除成功");
        }

        private void Button1_Click(object sender, EventArgs e)
        {
            Application.Restart();
        }

        private void button2_Click(object sender, EventArgs e)
        {            
            App.SYS_Function sYS_Function = new App.SYS_Function();
            sYS_Function.Show();
            this.Hide();
        }
    }
}
