<?php
/***************************************
## Theme URI: https://www.chenxingweb.com/wordpress-theme-cx-multi.html
## Author: 晨星博客
## Author URI: https://www.chenxingweb.com
## Description: 简洁时尚自适应博客杂志类主题，有问题请加QQ群597157500请求帮助。
## Theme Name: CX-MULTI
## Version: 1.0
****************************************/

get_header();
?>
<div class="multi-single-header layui-clear">
    <div class="multi-main-box">
        <div class="layui-col-md12">
            <div class="multi-breadcrimb-box">
                <i class="iconfont layui-extend-location" style="font-weight: 600;"></i> 当前位置：
                <span class="layui-breadcrumb">
                    <a href="<?php echo home_url();?>">首页</a>
                    <?php
                    the_category('/');
                    ?>
                    <a href="<?php the_permalink();?>"><cite>正文</cite></a>
                </span>
            </div>
        </div>
    </div>
</div>

<div id="single-page" class="multi-content-area">
    <main class="multi-main-box">
        <div class="layui-row multi-content-main">
            <div class="layui-col-md8 layui-tmargin-15px multi-single-content">
                <?php
                // Start the Loop.
                while (have_posts()) : the_post();
                ?>

                <div class="layui-col-md12 multi-single-header">
                    <?php the_title('<h1>', '</h1>');?>
                    <div class="multi-single-meta layui-clear">
                        <div class="multi-left">
                            <i class="cxthemeicon cxicon-zhanghao" style="font-weight: 600;"></i>
                            <?php the_author();?>
                            <span style="padding:0 3px;">|</span>
                            <time datetime="<?php the_time('Y-m-d H:i:s');?>"><?php the_date('Y/m/d');?></time>
                        </div>
                        <div class="multi-right">
                            <div class="meta-comments multi-left" style="margin-left:10px;"><i class="cxthemeicon cxicon-liulan"></i> <?php echo (int)get_post_meta(get_the_ID(), 'views', true);?></div> 
                            <?php the_tags('<div class="meta-tags multi-left" style="margin-left:15px;"><i class="cxthemeicon cxicon-tubiao4"></i> ', '、', '</div>');?>       
                            
                        </div>
                    </div>
                    <!-- .entry-meta -->
                </div>
                <div class="layui-col-md12">
                    <div class="multi-single-main">
                        <article id="post-<?php the_ID(); ?>" class="post-countent-data layui-text">
                            <?php the_content();?>
                        </article>
                        <div class="cxtheme-view-share">
                            <div class="bottom-single-data">
                                <div class="layui-btn-container">
                                    <button class="layui-btn layui-btn-radius layui-btn-danger cxbtn-postlive cxajax-action-js <?php echo isset($_COOKIE['_postlive_'.get_the_ID()]) ? 'cxajax-on' : '';?>" data-action="cxajax_postlive" data-postid="<?php the_ID();?>">
                                        <i class="cxthemeicon cxicon-icon-xiangqu" style="font-weight: bold;font-size: 14px;"></i>
                                        <i class="cxthemeicon cxicon-icon-xiangqufill" style="font-weight: bold;font-size: 14px;"></i>
                                        <span><?php echo (int)get_post_meta(get_the_ID(), '_cx_postlive', true);?>人喜欢</span>
                                    </button>
                                    <!--
                                    <button class="layui-btn layui-btn-radius layui-btn-normal">分享给朋友</button>
                                    -->
                                </div>
                            </div>
                            <p class="cxtheme-ycdesc-text">声明：原创文章请勿转载，如需转载请注明出处！</p>
                        </div>
                    </div>
                </div><!-- col.md12 -->

                <div class="layui-col-md12 layui-tmargin-15px">
                    <div class="cxtheme-nextandprev-box">
                        <div class="cxnextadnprev-box cxprev-box">
                            <?php
                            $prevpost = get_adjacent_post(false, $post_id,true);
                            if( $prevpost ){
                                $prev_postid    = $prevpost->ID;
                                $prev_posttitle = $prevpost->post_title;
                                $prev_postlink  = get_the_permalink($prev_postid);
                                ?>
                                <a href="<?php echo $prev_postlink;?>" class="flex paged-item">
                                    <div class="paged-thumb h-scale">
                                        <i class="thumb" style="background-image:url(<?php echo cx_post_thumb($prev_postid);?>)"></i>
                                    </div>
                                    <div class="paged-main">
                                        <h5><i class="cxthemeicon cxicon-chevron-left"></i> 上一篇</h5>
                                        <h3><?php echo $prev_posttitle;?></h3>
                                    </div>
                                </a>
                                <?php
                            }else{
                                ?>
                                <a href="javascript:;" target="_blank" class="flex paged-item">
                                    <div class="paged-thumb h-scale">
                                        <i class="thumb" style="background-image:url(<?php echo cx_option('_defimages');?>)"></i>
                                    </div>
                                    <div class="paged-main">
                                        <h5><i class="cxthemeicon cxicon-chevron-left"></i> 下一篇</h5>
                                        <h3>已经是第一篇了</h3>
                                    </div>
                                </a>
                                <?php
                            }
                            ?>
                        </div>
                        <div class="cxnextadnprev-box cxnext-box">
                            <?php
                            $nextpost = get_adjacent_post(false, $post_id,false);
                            if( $nextpost ){
                                $next_postid    = $nextpost->ID;
                                $next_posttitle = $nextpost->post_title;
                                $next_postlink  = get_the_permalink($next_postid);
                                ?>
                                <a href="<?php echo $next_postlink;?>" class="flex paged-item">
                                    <div class="paged-thumb h-scale">
                                        <i class="thumb" style="background-image:url(<?php echo cx_post_thumb($next_postid);?>)"></i>
                                    </div>
                                    <div class="paged-main">
                                        <h5><i class="cxthemeicon cxicon-chevron-left"></i> 下一篇</h5>
                                        <h3><?php echo $next_posttitle;?></h3>
                                    </div>
                                </a>
                                <?php
                            }else{
                                ?>
                                <a href="javascript:;" target="_blank" class="flex paged-item">
                                    <div class="paged-thumb h-scale">
                                        <i class="thumb" style="background-image:url(<?php echo cx_option('_defimages');?>)"></i>
                                    </div>
                                    <div class="paged-main">
                                        <h5><i class="cxthemeicon cxicon-chevron-left"></i> 下一篇</h5>
                                        <h3>已经是最新了</h3>
                                    </div>
                                </a>
                                <?php
                            }
                            ?>
                        </div>
                    </div> <!-- nextandprev.end -->
                </div>

                <?php
                endwhile; // End the loop.
                ?>

            </div>

            <?php
            get_sidebar();
            ?>

        </div>

    </main><!-- #main -->

    
    <div class="layui-row multi-xgpost-box">
        <div class="multi-main-box">
            <div class="multi-main-title">
                <h2>相关文章</h2>
                <i class="cxthemeicon cxicon-hot" style="color: #f66;margin-left: 5px;"></i>
            </div>
            <ul class="multi-postlist layui-clear">
                <?php 
                $xg_args = array(
                    'post_type'      => get_post_type(),
                    'post__not_in'   => [get_the_ID()],
                    'posts_per_page' => 4,
                    'ignore_sticky_posts' => 1
                );
                $post_tag = get_the_tags();
                $tag_arr  = [];
                if( $post_tag ){
                    foreach ($post_tag as $tag_value) {
                        $tag_arr[] = $tag_value->term_id;
                    }
                    $xg_args['tag__and'] = $tag_arr;
                }  
                $xgpost_query = new WP_Query($xg_args);
                // The Loop
                if ( $xgpost_query->have_posts() ):
                    while ( $xgpost_query->have_posts() ): $xgpost_query->the_post();
                        cx_template_html( '','<li>', '</li>');
                    endwhile;
                else:
                    unset($xg_args['tag__and']);
                    $xgpost_query = new WP_Query($xg_args);
                    // The Loop
                    if ( $xgpost_query->have_posts() ):
                        while ( $xgpost_query->have_posts() ): $xgpost_query->the_post();
                            cx_template_html( '','<li>', '</li>');
                        endwhile;
                    endif; 
                endif;
                wp_reset_postdata();              
                ?>
            </ul>
        </div>
    </div>
</div><!-- #primary -->

<?php
get_footer();
