<?php
/***************************************
## Theme URI: https://www.chenxingweb.com/wordpress-theme-cx-multi.html
## Author: 晨星博客
## Author URI: https://www.chenxingweb.com
## Description: 简洁时尚自适应博客杂志类主题，有问题请加QQ群597157500请求帮助。
## Theme Name: CX-MULTI
## Version: 1.0
****************************************/
?>

<?php if ( ! defined( 'ABSPATH' )  ) die; // Cannot access directly.

//
// Set a unique slug-like ID
//
$prefix = MD5(CX_THEMES_NAME);

//
// Create options
//
CSF::createOptions( $prefix, [
  'menu_title' => '主题配置面板',
  'menu_slug'  => 'cxwp-theme-panel',
] );

//
// Create a section
//
CSF::createSection( $prefix, [
  'title'       => '主题说明',
  'icon'        => 'fas fa-rocket',
  'description' => '<div class="groups_title"><h3>欢迎使用CX-MULTI免费主题</h3><p>尊敬的用户您好！感谢您支持我的作品，一套优秀的作品离不开大家的共同维护和支持，希望大家在做站过程中注意一下几点防止网站被非法人员利用！</p><p style="margin-top:20px;">1. 尽量选择靠谱的主机商，如果选择不当，我们辛辛苦苦做的网站以及用户信息可能会被非法利用！</p><p>2. 不要把网站管理员密码及服务器密码发送给其他人，防止别人恶意利用破坏网络环境影响您的使用，如果有开发需求请选择靠谱的开发人员！</p><p>3. 站点管理员帐号用户名避免使用‘admin’，‘root’等常见的命名，密码尽量设置复杂一些，避免网站因为弱口令被破解入侵！</p><br><h3>售后联系方式</h3><p>1. 提交工单 ：<a href="https://www.chenxingweb.com/users?tab=work">点击提交</a></p><p>2. 作者 Q Q ：1021680574</p><p>3. 用户QQ群：565616228</p><br><h3>主题在线文档</h3><p>1. <a href="https://www.chenxingweb.com/docs/1511.html">WordPress通用文档</a> （新手站长建议浏览）</p><p>2. <a href="https://www.chenxingweb.com/docs/1439.html">CX-MULTI专用文档</a> </p><p>3. 借力搜索引擎，WordPress作为一个成熟的CMS程序，很多问题网上都有很全面的教程！ </p><br><h3>关注作者</h3><p>1. 官方博客：<a href="https://www.chenxingweb.com">www.chenxingweb.com</a></p><p>2. 微信公众号: 晨星网络服务</p><p>3. 作者QQ: 1021680574</p></div>',
  'fields'      => []
] );

CSF::createSection( $prefix, array(
    'title'       => '常规配置',
    'icon'        => 'cxthemeicon cxicon-fabu',
    'description' => '调整网站基本功能配置项。',
    'fields'      => array(

        array(
            'id'       => '_defimages',
            'type'     => 'upload',
            'title'    => '上传网站默认图片',
            'library'  => 'image',
            'after'    => '<p>如果文章调用不到封面图会自动调用该图作为封面显示！</p>',
            'button_title' => '上传图片',   
            'default' => get_theme_file_uri('images/noimage.gif'), 
        ),

    )
) );


CSF::createSection( $prefix, array(
    'title'       => '顶部配置',
    'icon'        => 'fas fa-book-reader',
    'description' => '调整网站基本功能配置项。',
    'fields'      => array(

        array(
            'id'       => 'header-logo',
            'type'     => 'upload',
            'title'    => '上传网站Logo图片',
            'library'  => 'image',
            'after'    => '<p>该Logo将显示在前台顶部Header模块中！</p>',
            'default'  => get_theme_file_uri('images/theme-logo.png'),
            'button_title' => '上传Logo',
    
        ),

        array(
            'id'      => 'header-login',
            'type'    => 'switcher',
            'title'   => '顶部显示登录&注册按钮',
            'label'   => '开启之后在主题顶部右侧会显示登录和注册按钮！',
            'default' => true,
        ),
  
    )
) );

CSF::createSection( $prefix, array(
    'title'       => '首页配置',
    'icon'        => 'cxthemeicon cxicon-shouye',
    'description' => '调整网站基本功能配置项。',
    'fields'      => array(

        array(
            'id'       => 'index-slide-num',
            'type'     => 'spinner',
            'title'    => '幻灯片调用数量',
            'after'    => '设置幻灯片模块调用的文章数量！',
            'min'      => 1,
            'step'     => 1,
            'default'  => 3,
        ),

        array(
            'id'      => 'index-zt',
            'type'    => 'switcher',
            'title'   => '首页专题模块',
            'default' => true,
        ),

        array(
            'id'     => 'index-zt-data',
            'type'   => 'group',
            'title'  => '专题内容管理',
            'button_title' => '添加新专题',
            'fields' => array(
              array(
                'id'    => 'opt-text',
                'type'  => 'text',
                'title' => '专题名称',
              ),
              array(
                'id'      => 'opt-show',
                'type'    => 'switcher',
                'title'   => '是否推送至前台显示',
                'default' => true,
              ),
              array(
                'id'    => 'opt-url',
                'type'  => 'text',
                'title' => '专题跳转链接',
                'attributes' => array(
                    'style'  => 'width: 100%;',
                ),
              ),
              array(
                'id'    => 'opt-images',
                'type'  => 'upload',
                'title' => '专题封面图片',
              ),
            ),
            'default' => array(
              array(
                'opt-text'   => '专题演示一',
                'opt-show'   => true,
                'opt-url'    => 'https://www.chenxingweb.com',
                'opt-images' => get_theme_file_uri('images/ad-1.png'),
              ),
              array(
                'opt-text'   => '专题演示二',
                'opt-show'   => true,
                'opt-url'    => 'https://www.chenxingweb.com',
                'opt-images' => get_theme_file_uri('images/ad-2.png'),
              ),
              array(
                'opt-text'   => '专题演示三',
                'opt-show'   => true,
                'opt-url'    => 'https://www.chenxingweb.com',
                'opt-images' => get_theme_file_uri('images/ad-3.png'),
              ),
              array(
                'opt-text'   => '专题演示四',
                'opt-show'   => true,
                'opt-url'    => 'https://www.chenxingweb.com',
                'opt-images' => get_theme_file_uri('images/ad-4.png'),
              ),
            ),
            'dependency' => array('index-zt', '==', 'true'),
        ),

  
    )
) );
CSF::createSection( $prefix, array(
    'title'       => '底部配置',
    'icon'        => 'cxthemeicon cxicon-footer-bar',
    'description' => '调整网站基本功能配置项。',
    'fields'      => array(
        array(
            'id'      => 'footer-desc',
            'type'    => 'textarea',
            'title'   => '网站底部描述内容',
            'default' => '免责声明：本网站部分内容由用户自行上传，如权利人发现存在误传其作品情形，请及时与本站联系。',
        ),

        array(
            'id'      => 'footer-copyright',
            'type'    => 'textarea',
            'title'   => '网站底部版权信息',
            'default' => 'Copyright © 2013-2020 All Rights Reserved.',
        ),
  
    )
) );
CSF::createSection( $prefix, array(
    'title'       => '文章页配置',
    'icon'        => 'cxthemeicon cxicon-shuju',
    'description' => '调整网站基本功能配置项。',
    'fields'      => array(
        array(
            'id'      => 'single-pagebtn',
            'type'    => 'switcher',
            'title'   => '文章页显示上下篇文章！',
            'default' => true,
        ),
        array(
            'id'      => 'single-xgpost',
            'type'    => 'switcher',
            'title'   => '文章页显示相关文章模块',
            'default' => true,
        ),
  
    )
) );

return;

CSF::createSection( $prefix, array(
    'id'    => 'diycode_fields',
    'title' => '自定义代码',
    'icon'  => 'fas fa-code',
    'description' => '用于添加您的自定义代码[js,html.css],代码编写需要一定的编程基础，请勿放置错误的代码，代码异常会引发严重的网站错误！',
    'fields'      => array(
        // 自定义css
        array(
          'id'       => 'diycode_fields_css',
          'type'     => 'code_editor',
          'title'    => '自定义CSS代码',
          'position' => true,
          'settings' => array(
            'theme'  => 'mbo',
            'mode'   => 'css',
          ),
          'subtitle' => '该代码框里只允许输入CSS代码，输入框里的代码将加载到前台Head标签内！',
          'default'  => "/* 默认示例代码不加载,如需加载请修改输入框中的内容 */\n.diycode {\n  margin:0\n}",
        ),
    
        array(
          'id'       => 'diycode_fields_html',
          'type'     => 'code_editor',
          'title'    => '自定义HTML代码',
          'position' => true,
          'subtitle' => '该代码框里可以输入符合HTML规范的代码，代码将加载到body标签底部，只可添加悬浮、弹窗、定位类的代码，并配合匹配的css样式使用！',
          'settings' => array(
            'theme'  => 'shadowfox',
            'mode'   => 'htmlmixed',
          ),
          'default'  =>"/* 默认示例代码不加载,如需加载请修改输入框中的内容 */\n<div class=\"diycode\">\n\n</div>",
        ),
    
        array(
          'id'       => 'diycode_fields_js',
          'type'     => 'code_editor',
          'title'    => '自定义JS代码',
          'position' => true,
          'subtitle' => '该代码框里可以输入符合JS规范的代码，代码将加载到body标签底部，错误的代码可能引起全站js脚本失效！',
          'settings' => array(
            'theme'  => 'dracula',
            'mode'   => 'javascript',
          ),
          'default' =>"/* 默认示例代码不加载,如需加载请修改输入框中的内容 */\n$(document).ready( function() {\n  // code \n});",
        ),
    
    )
) );

// 网站优化类
CSF::createSection( $prefix, array(
    'title'       => '网站优化',
    'icon'        => 'cxthemeicon cxicon-youhua',
    'description' => '控制一些常用的优化项目的使用状况！',
    'fields'      => array(
  
        array(
            'id'      => 'optimize-json',
            'type'    => 'switcher',
            'title'   => '移除wp-json链接',
            'label'   => '开启之后head标签中将不再显示wp-json链接！',
            'default' => true,
        ),

        array(
            'id'      => 'optimize-emoji',
            'type'    => 'switcher',
            'title'   => '移除emoji脚本',
            'label'   => '开启之后head标签中将不再显示emoji相关的脚本和样式！',
            'default' => true,
        ),

        array(
            'id'      => 'optimize-head',
            'type'    => 'switcher',
            'title'   => '移除头部冗余代码',
            'label'   => '开启之后将对head中的冗余标签进行清理！',
            'default' => true,
        ),

        array(
            'id'      => 'optimize-embeds',
            'type'    => 'switcher',
            'title'   => '禁用embeds功能',
            'label'   => '开启之后将禁用embeds功能，页面底部不再加载embeds.min.js脚本！',
            'default' => true,
        ),

        array(
            'id'      => 'optimize-google',
            'type'    => 'switcher',
            'title'   => '禁用谷歌字体',
            'label'   => '开启之后将禁用谷歌字体！',
            'default' => true,
        ),

        array(
            'id'      => 'optimize-library',
            'type'    => 'switcher',
            'title'   => '禁止加载 block-library CSS文件',
            'label'   => 'WordPress版本 5.0+ 并且没有使用新的块编辑器（古腾堡）的用户可以关闭！',
            'default' => false,
        ),       

    )
) );